#!/usr/bin/env python
# -*- coding: UTF-8 -*-

from __future__ import print_function
from . import _
from . import Utils
from Components.ActionMap import ActionMap
from Components.Button import Button
from Components.Label import Label
from Components.MenuList import MenuList
from Components.ScrollLabel import ScrollLabel
from Components.Sources.List import List
from Plugins.Plugin import PluginDescriptor
from Screens.Console import Console
from Screens.MessageBox import MessageBox
from Screens.Screen import Screen
from Screens.Standby import TryQuitMainloop
from enigma import eTimer
from enigma import gFont
from os import listdir
from os import sys
from skin import loadSkin
from twisted.web.client import getPage
from xml.dom import minidom
import os

PY3 = sys.version_info.major >= 3
if PY3:
    from urllib.request import urlopen
else:
    from urllib2 import urlopen

currversion = '5.3'

plugin_path = '/usr/lib/enigma2/python/Plugins/Extensions/AddOnJaphar/'
loadSkin(plugin_path + '/images/skin.xml')


def checkStr(text, encoding='utf8'):
    if PY3:
        if isinstance(text, type(bytes())):
            text = text.decode('utf-8')
    else:
        if isinstance(text, unicode):
            text = text.encode(encoding)
    return text


class gpupdatesScreen(Screen):

    def __init__(self, session):
        Screen.__init__(self, session)
        info = ''
        self['text'] = ScrollLabel(info)
        self['actions'] = ActionMap(['SetupActions',
                                     'DirectionActions'], {'ok': self.close,
                                                           'cancel': self.close,
                                                           'up': self['text'].pageUp,
                                                           'down': self['text'].pageDown,
                                                           'left': self['text'].pageUp,
                                                           'right': self['text'].pageDown}, -1)
        try:
            fp = urlopen('http://jam.japhar.com/download/addons/updates.txt')
            count = 0
            self.labeltext = ''
            while 1:
                s = fp.readline()
                count += 1
                self.labeltext += str(s)
                if not s:
                    break

            fp.close()
            self['text'].setText(self.labeltext)
        except:
            self['text'].setText('Error in downloading updates')


class addonsupdatesScreen(Screen):

    def __init__(self, session):
        Screen.__init__(self, session)
        info = ''
        self['text'] = ScrollLabel(info)
        self['actions'] = ActionMap(['OkCancelActions',
                                     'DirectionActions'],
                                    {'ok': self.close,
                                     'cancel': self.close,
                                     'up': self['text'].pageUp,
                                     'down': self['text'].pageDown,
                                     'left': self['text'].pageUp,
                                     'right': self['text'].pageDown},
                                    -1)
        try:
            fp = urlopen('http://jam.japhar.com/download/addons/addons-updates.txt')
            count = 0
            self.labeltext = ''
            while 1:
                s = fp.readline()
                count += 1
                self.labeltext += str(s)
                if not s:
                    break

            fp.close()
            self['text'].setText(self.labeltext)
        except:
            self['text'].setText('unable to download updates')


class AboutScreen(Screen):

    def __init__(self, session):
        Screen.__init__(self, session)
        info = '\n Japhar Addons/Plugin v. %s\n ---------------------------------------------------------------------- \n\n Addons/Plugin Tool connects all enigma2\n images with Server for downloading\n plugins, skins...\n\n ---------------------------------------------------------------------- \n                      www.japhar.com\n                    (c) WarLord 2015' % currversion
        self['text'] = ScrollLabel(info)
        self['key_yellow'] = Button(_('Server news'))
        self['actions'] = ActionMap(['SetupActions',
                                     'DirectionActions',
                                     'ColorActions'], {'ok': self.close,
                                                       'yellow': self.shownews,
                                                       'up': self['text'].pageUp,
                                                       'down': self['text'].pageDown,
                                                       'left': self['text'].pageUp,
                                                       'right': self['text'].pageDown,
                                                       'cancel': self.close}, -1)

    def shownews(self):
        self.session.open(addonsupdatesScreen)


class AddonsGroups(Screen):

    def __init__(self, session):
        Screen.__init__(self, session)
        self['key_red'] = Button(_('Exit'))
        self['key_green'] = Button(_('Update Plugin'))
        self['key_yellow'] = Button(_('Ipk Manual'))
        self['key_blue'] = Button(_('About'))
        self.list = []
        self['list'] = MenuList([])
        # self["list"] = List([])
        self['info'] = Label()
        self['fspace'] = Label()
        self.addon = 'emu'
        self.icount = 0
        self.downloading = False
        self['info'].setText('Downloading addons groups, Please wait...')
        self.timer = eTimer()
        if Utils.DreamOS():
            self.timer_conn = self.timer.timeout.connect(self.downloadxmlpage)
        else:
            self.timer.callback.append(self.downloadxmlpage)
        self.timer.start(100, 1)

        self['actions'] = ActionMap(['OkCancelActions',
                                     'ColorActions'],
                                    {'ok': self.okClicked,
                                     'blue': self.ShowAbout,
                                     'yellow': self.ShowIPKmnl,
                                     'green': self.pluginupdate,
                                     'red': self.cancel,
                                     'cancel': self.cancel},
                                    -2)

    def cancel(self):
        self.close()

    def ShowIPKmnl(self):
        self.session.open(IPKmanual)

    def updateable(self):
        try:
            selection = str(self.names[0])
            lwords = selection.split('_')
            lv = lwords[1]
            self.lastversion = lv
            if float(lv) == float(currversion):
                return False
            if float(lv) > float(currversion):
                return True
            return False
        except:
            return False

    def ShowAbout(self):
        self.session.open(AboutScreen)

    def pluginupdate(self):
        softupdate = self.updateable()
        if softupdate is True:
            com = 'http://jam.japhar.com/download/addons/japhar-addons-manager_' + self.lastversion + '_DM_oe16_all.ipk'
        else:
            self.session.open(MessageBox, 'Plugin is up-to-date', MessageBox.TYPE_WARNING, 2)
            return
        dom = 'Japhar Addons Manager ' + self.lastversion
        self.session.open(Console, _('downloading-installing: %s') % dom, ['opkg install -force-overwrite %s' % com])

    def downloadxmlpage(self):
        url = 'http://fam.japhar.com/download/addons/addons.xml'
        getPage(str.encode(url)).addCallback(self._gotPageLoad).addErrback(self.errorLoad)
        # getPage(url).addCallback(self._gotPageLoad).addErrback(self.errorLoad)

    def errorLoad(self, error):
        print(str(error))
        self['info'].setText('Addons Download Failure, No internet connection or Server down !')
        self.downloading = False

    def _gotPageLoad(self, data):
        self.xml = checkStr(data)
        # print('self.xml:', self.xml)
        try:
            if self.xml:
                self.xmlparse = minidom.parseString(self.xml)
            else:
                self.downloading = False
                self['info'].setText('Addons Download Failure, No internet connection or server down !')
                return
            self.data = []
            icount = 0
            for plugins in self.xmlparse.getElementsByTagName('plugins'):
                if PY3:
                    self.list.append(plugins.getAttribute('cont'))
                else:
                    self.list.append(plugins.getAttribute('cont').encode('utf8'))

            self['info'].setText('')
            self['list'].setList(self.list)
            self.downloading = True
        except:
            self.downloading = False
            self['info'].setText('Error processing server addons data.')

    def okClicked(self):
        if self.downloading is True:
            selection = str(self['list'].getCurrent())
            print('selection list : ', selection)
            self.session.open(IpkgPackages, self.xmlparse, selection)
        else:
            self.close


class IpkgPackages(Screen):

    def __init__(self, session, xmlparse, selection):
        Screen.__init__(self, session)
        self.xmlparse = xmlparse
        self.selection = selection
        list = []
        self['countrymenu'] = MenuList(list)
        # for plugins in self.xmlparse.getElementsByTagName('plugins'):
            # if PY3:
                # if str(plugins.getAttribute('cont')) == self.selection:
                    # for plugin in plugins.getElementsByTagName('plugin'):
                        # list.append(plugin.getAttribute('name'))
            # else:
                # if str(plugins.getAttribute('cont').encode('utf8')) == self.selection:
                    # for plugin in plugins.getElementsByTagName('plugin'):
                        # list.append(plugin.getAttribute('name').encode('utf8'))

        # list.sort()
        # # list.sort(key=lambda i: i[0], reverse=True)
        # # # self["countrymenu"] = List([])
        # self['countrymenu'].setList(list)
        self['actions'] = ActionMap(['OkCancelActions',
                                     'ColorActions'], {'ok': self.selclicked,
                                                       'cancel': self.cancel,
                                                       'red': self.selremoved,
                                                       'green': self.selremoved,
                                                       'yellow': self.seldowngrade,
                                                       'blue': self.seldowngrade,
                                                       }, -2)
        self.timer = eTimer()
        if Utils.DreamOS():
            self.timer_conn = self.timer.timeout.connect(self.updateMenuList)
        else:
            self.timer.callback.append(self.updateMenuList)
        self.timer.start(100, 1)

    def updateMenuList(self):
        list = []
        for plugins in self.xmlparse.getElementsByTagName('plugins'):
            if PY3:
                if str(plugins.getAttribute('cont')) == self.selection:
                    for plugin in plugins.getElementsByTagName('plugin'):
                        list.append(plugin.getAttribute('name'))
            else:
                if str(plugins.getAttribute('cont').encode('utf8')) == self.selection:
                    for plugin in plugins.getElementsByTagName('plugin'):
                        list.append(plugin.getAttribute('name').encode('utf8'))
        list.sort()
        # showlist(list, self['countrymenu'])
        self['countrymenu'].setList(list)
        
    def cancel(self):
        self.close()

    def selclicked(self):
        try:
            selection_country = self['countrymenu'].getCurrent()
        except:
            return

        for plugins in self.xmlparse.getElementsByTagName('plugins'):
            if PY3:
                if str(plugins.getAttribute('cont')) == self.selection:
                    for plugin in plugins.getElementsByTagName('plugin'):
                        if plugin.getAttribute('name') == selection_country:
                            self.com = str(plugin.getElementsByTagName('url')[0].childNodes[0].data)
                            self.dom = plugin.getAttribute('name')
                            self.prombt()
            else:
                if str(plugins.getAttribute('cont').encode('utf8')) == self.selection:
                    for plugin in plugins.getElementsByTagName('plugin'):
                        if plugin.getAttribute('name').encode('utf8') == selection_country:
                            self.com = str(plugin.getElementsByTagName('url')[0].childNodes[0].data)
                            self.dom = plugin.getAttribute('name').encode('utf8')
                            self.prombt()


    def prombt(self,  answer=None):
        if answer is None:
            self.session.openWithCallback(self.prombt, MessageBox, _("Install select package\nDo you really want to continue?"))
        else:
            if self.selection == 'Skins':
                self.session.openWithCallback(self.callMyMsg, MessageBox, _('Do not install any skin unless you are sure it is compatible with your image.Are you sure?'), MessageBox.TYPE_YESNO)
            else:
                self.session.open(Console, _('downloading-installing: %s') % self.dom, ['opkg install --force-overwrite %s' % self.com])

    def callMyMsg(self, result):
        if result:
            self.session.open(Console, _('downloading-installing: %s') % self.dom, ['opkg install --force-overwrite %s' % self.com])

    def selremoved(self):
        try:
            selection_country = self['countrymenu'].getCurrent()
        except:
            return

        for plugins in self.xmlparse.getElementsByTagName('plugins'):
            if PY3:
                if str(plugins.getAttribute('cont')) == self.selection:
                    for plugin in plugins.getElementsByTagName('plugin'):
                        if plugin.getAttribute('name') == selection_country:
                            self.com = str(plugin.getElementsByTagName('url')[0].childNodes[0].data)
                            self.dom = plugin.getAttribute('name')
                            # self.prombtremoved()
            else:
                if str(plugins.getAttribute('cont').encode('utf8')) == self.selection:
                    for plugin in plugins.getElementsByTagName('plugin'):
                        if plugin.getAttribute('name').encode('utf8') == selection_country:
                            self.com = str(plugin.getElementsByTagName('url')[0].childNodes[0].data)
                            self.dom = plugin.getAttribute('name').encode('utf8')
            self.prombtremoved()

    def prombtremoved(self, answer=None):
        if answer is None:
            self.session.openWithCallback(self.prombtremoved, MessageBox, _("Remove select package\nDo you really want to continue?"))
        else:
            if self.selection == 'Skins':
                self.session.openWithCallback(self.callMyMsgRemove, MessageBox, _('Do not remove any skin unless you are sure it is compatible with your image.Are you sure?'), MessageBox.TYPE_YESNO)
            else:
                self.session.open(Console, _('downloading-removing: %s') % self.dom, ['opkg remove %s' % self.com])

    def callMyMsgRemove(self, result):
        if result:
            self.session.open(Console, _('downloading-removing: %s') % self.dom, ['opkg remove %s' % self.com])

    def seldowngrade(self):
        try:
            selection_country = self['countrymenu'].getCurrent()
        except:
            return
        if PY3:
            for plugins in self.xmlparse.getElementsByTagName('plugins'):
                if str(plugins.getAttribute('cont')) == self.selection:
                    for plugin in plugins.getElementsByTagName('plugin'):
                        if plugin.getAttribute('name') == selection_country:
                            self.com = str(plugin.getElementsByTagName('url')[0].childNodes[0].data)
                            self.dom = plugin.getAttribute('name')
                            # self.prombtdowngrade()
        else:
            for plugins in self.xmlparse.getElementsByTagName('plugins'):
                if str(plugins.getAttribute('cont').encode('utf8')) == self.selection:
                    for plugin in plugins.getElementsByTagName('plugin'):
                        if plugin.getAttribute('name').encode('utf8') == selection_country:
                            self.com = str(plugin.getElementsByTagName('url')[0].childNodes[0].data)
                            self.dom = plugin.getAttribute('name').encode('utf8')
        self.prombtdowngrade()

    def prombtdowngrade(self, answer=None):
        if answer is None:
            self.session.openWithCallback(self.prombtdowngrade, MessageBox, _("Remove select package\nDo you really want to continue?"))
        else:
            if self.selection == 'Skins':
                self.session.openWithCallback(self.callMyMsgDowngrade, MessageBox, _('Do not install any skin unless you are sure it is compatible with your image.Are you sure?'), MessageBox.TYPE_YESNO)
            else:
                self.session.open(Console, _('downloading-downgrading: %s') % self.dom, ['opkg install -force-downgrade %s' % self.com])

    def callMyMsgDowngrade(self, result):
        if result:
            self.session.open(Console, _('downloading-downgrading: %s') % self.dom, ['opkg install -force-downgrade %s' % self.com])


class IPKmanual(Screen):

    def __init__(self, session):
        Screen.__init__(self, session)
        self.flist = []
        idx = 0
        ipkpth = ("/tmp")
        pkgs = listdir("/tmp")
        for fil in pkgs:
            if fil.find('.ipk') != -1:
                res = (fil, idx)
                self.flist.append(res)
                idx += 1
        self['Title'] = Label(_('Install Manual Ipk'))
        self['Title2'] = Label(_('Select Package from /tmp to Install'))
        self['key_red'] = Label(_('Close'))
        self['key_green'] = Label(_('Install'))
        self['ipkglist'] = List(self.flist)
        self['actions'] = ActionMap(['OkCancelActions', 'WizardActions', 'ColorActions'],
                                    {
                                     'ok': self.ipkginst,
                                     'red': self.cancel,
                                     'green': self.ipkginst,
                                     'cancel': self.cancel}, -1)

    def cancel(self):
        self.close()

    def ipkginst(self):
        self.sel = self['ipkglist'].getCurrent()
        if self.sel:
            self.sel = self.sel[0]
            message = _('Do you really want to install the selected Addon')+_(' :\n ') + self.sel + _(' ?')
            ybox = self.session.openWithCallback(self.ipkginst2, MessageBox, message, MessageBox.TYPE_YESNO)
            ybox.setTitle(_('IPK Manual Installation'))

    def ipkginst2(self, answer):
        if answer is True:
            ipkpth = ("/tmp")
            dest = ipkpth + '/' + self.sel
            mydir = os.getcwd()
            os.chdir('/')
            cmd0 = 'opkg install --noaction %s > /tmp/package.info' % dest
            cmd1 = 'opkg install --force-overwrite ' + dest
            self.session.open(Console, title='IPK Manual Installation', cmdlist=[cmd0, cmd1, 'sleep 5'], finishedCallback=self.msginst)
            os.chdir(mydir)

    def msginst(self):
        self.session.openWithCallback(self.extrstrt, MessageBox, _("Do you want restart enigma2 to reload installed addons ?"), MessageBox.TYPE_YESNO)

    def extrstrt(self, result):
        if result:
            self.session.open(TryQuitMainloop, 3)
        else:
            self.close()


def main(session, **kwargs):
    session.open(AddonsGroups)


def Plugins(**kwargs):
    return PluginDescriptor(name='Japhar Addons Manager %s' % currversion,
                            description=_('Download your favorite plugin !'),
                            where=[PluginDescriptor.WHERE_EXTENSIONSMENU, PluginDescriptor.WHERE_PLUGINMENU], icon='images/addons.png', fnc=main)
